/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.affix.core.GoalAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class DesecratingAffix
extends GoalAffix {
    public DesecratingAffix() {
        super("desecrating", AffixCategory.OFFENSE);
    }

    @Override
    public boolean onAttacked(IChampion champion, DamageSource source, float amount) {
        return !(source.m_7639_() instanceof AreaEffectCloud) || source.m_7640_() != champion.getLivingEntity();
    }

    @Override
    public List<Tuple<Integer, Goal>> getGoals(IChampion champion) {
        return Collections.singletonList(new Tuple((Object)0, (Object)new DesecrateGoal((Mob)champion.getLivingEntity())));
    }

    public static class DesecrateGoal
    extends Goal {
        private final Mob mobEntity;
        private int attackTime;

        public DesecrateGoal(Mob mobEntity) {
            this.mobEntity = mobEntity;
        }

        public void m_8056_() {
            this.attackTime = ChampionsConfig.desecratingCloudInterval * 20;
        }

        public void m_8037_() {
            LivingEntity target = this.mobEntity.m_5448_();
            --this.attackTime;
            if (this.attackTime <= 0 && target != null) {
                this.attackTime = ChampionsConfig.desecratingCloudInterval * 20 + this.mobEntity.m_21187_().nextInt(5) * 10;
                AreaEffectCloud cloud = new AreaEffectCloud(target.m_183503_(), target.m_20182_().f_82479_, target.m_20182_().f_82480_, target.m_20182_().f_82481_);
                cloud.m_19718_((LivingEntity)this.mobEntity);
                cloud.m_19712_((float)ChampionsConfig.desecratingCloudRadius);
                cloud.m_19734_(ChampionsConfig.desecratingCloudDuration * 20);
                cloud.m_19732_(-0.5f);
                cloud.m_19740_(ChampionsConfig.desecratingCloudActivationTime * 20);
                cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
                cloud.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, 1));
                target.m_183503_().m_7967_((Entity)cloud);
            }
        }

        public boolean m_8036_() {
            return BasicAffix.canTarget((LivingEntity)this.mobEntity, this.mobEntity.m_5448_(), true);
        }
    }
}

